#!/usr/bin/env bash

script_name=$(basename -- "$0")
echo "EXECUTE SCRIPT: $script_name"
echo "$script_name : pwd"
pwd
ls -la

echo "$script_name : ruby version: $(ruby -v)"

echo "$script_name : cd to veteran-appointment-requests/test/watir-ruby. (MUST do this for running tests properly)"
cd veteran-appointment-requests/test/watir-ruby

echo "$script_name : bundle install using default Gemfile"
bundle install --binstubs 

echo "$script_name : Run all rspec tests"
bundle exec rspec spec/. --format html --out rspec_results.htm

echo "$script_name : pwd"
pwd

echo "$script_name : List files in current dir"
ls -la

echo "$script_name : List files in screenshots dir"
ls -la screenshots_${BUILD_NUMBER}/

echo "$script_name : Move screenshots and results to archive to /out directory to be copied out and archived"
mv screenshots_${BUILD_NUMBER}/* ../../../out/
mv rspec_results*.html ../../../out/

echo "$script_name : Trigger acceptance-test_status.sh running on Jenkins to copy out necessary files"
echo "Acceptance Tests Complete"